public class Newton {
    public static double newt(MathFunctionNewton func, double a, double b, double epsilon) {
        double guess= 0.5*(a + b);		// No real bracket, only a guess
        for (int j= 0; j < JMAX; j++) {
            double fval= func.fn(guess);
            double fder= func.fd(guess);
            double dx= fval/fder;
            guess -= dx;
            System.out.println(guess);
            if ((a - guess)*(guess - b) < 0.0) {
                System.out.println("Error: out of bracket");	// Conservative
                return ERR_VAL;
            }
            if (Math.abs(dx) < epsilon)
                return guess;
        }
        System.out.println("Maximum iterations exceeded");
        return guess;
    }
    public static final int JMAX= 50;
    public static final double ERR_VAL= -10E10;
    
    public static void main(String[] args) {
        double root= Newton.newt(new Quad(), -0.0, 8.0, 0.0001);
        System.out.println("Root: " + root);
        System.out.println();
    }
}